string GetDescription()
{
	return "Renders the harmony into arpegiated chords. Has many patterns of arpeggio.";
}

void Render(RenderPart @p)
{
	double step = 1.0;
	if (p.GetTempo() < 70) step /= 2.0;
	
	int base = RndInt(-2,2);
	int mode = RndInt(0,1);
	
	int up = 1;
	int down = RndInt(1,2);
	
	int n = RndInt(0,1);
	
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		int w = 0;
		
		
		for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=step)
		{
			int harm = p.GetHarmonic(CreateTime(i,m));
			
			int pitch = p.GetHarmonicEventPitch(harm, base);
			
			if (m + step >= p.GetUniquePart().GetMetrum() && n == 0)
			{
				for (int t = 0; t < 6; t++)
				{
					pitch = p.AlignPitch(p.GetHarmonicEventPitch(harm, base),t%2);
					if (t == 0) p.AddNote(CreateTime(i,m + step/6.0*t), CreateTime(i,m+0.1+ step/6.0*t), pitch, RndInt(80,110));		
					else p.AddNote(CreateTime(i,m + step/6.0*t), CreateTime(i,m+0.1+ step/6.0*t), pitch, RndInt(60,80));		
				}
			}
			else
			{
				p.AddNote(CreateTime(i,m), CreateTime(i,m+0.1), pitch, RndInt(90,110));
				
				if (n == 0 || w % 2 == 0)
				{
					if (mode == 0)
					{
						pitch = p.GetHarmonicEventPitch(harm, base+up);
						p.AddNote(CreateTime(i,m+step*2.0/6.0), CreateTime(i,m+0.1+step*2.0/6.0), pitch, RndInt(80,95));
						pitch = p.GetHarmonicEventPitch(harm, base-down);
						p.AddNote(CreateTime(i,m+step*4.0/6.0), CreateTime(i,m+0.1+step*4.0/6.0), pitch, RndInt(80,95));
					}
					else
					{
						pitch = p.GetHarmonicEventPitch(harm, base-down);
						p.AddNote(CreateTime(i,m+step*2.0/6.0), CreateTime(i,m+0.1+step*2.0/6.0), pitch, RndInt(80,95));
						pitch = p.GetHarmonicEventPitch(harm, base+up);
						p.AddNote(CreateTime(i,m+step*4.0/6.0), CreateTime(i,m+0.1+step*4.0/6.0), pitch, RndInt(80,95));
					}
				}
			}
			
			w++;
			
		}
		
		if(n == 0) n = 1;
		else n = 0;
	}
	
	
}
